Ext.data.JsonP.sol_common_ix_functions_Inherit({"tagname":"class","name":"sol.common.ix.functions.Inherit","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.functions.Inherit.js","href":"sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.02.003"],"eloix":true,"requires":["sol.common.AsyncUtils","sol.common.Config","sol.common.ConfigMixin","sol.common.JsonUtils","sol.common.ObjectUtils","sol.common.RepoUtils","sol.common.SordUtils","sol.common.StringUtils","sol.common.WfUtils","sol.common.ix.FunctionBase","sol.common.ix.RfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.FunctionBase","mixins":[],"uses":[],"members":[{"name":"fields","tagname":"cfg","owner":"sol.common.ix.functions.Inherit","id":"cfg-fields","meta":{}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.functions.Inherit","id":"cfg-objId","meta":{"required":true}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.ix.functions.Inherit","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"sleepTime","tagname":"cfg","owner":"sol.common.ix.functions.Inherit","id":"cfg-sleepTime","meta":{}},{"name":"waitUntilFinished","tagname":"cfg","owner":"sol.common.ix.functions.Inherit","id":"cfg-waitUntilFinished","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"parentSord","tagname":"property","owner":"sol.common.ix.functions.Inherit","id":"property-parentSord","meta":{"private":true}},{"name":"sord","tagname":"property","owner":"sol.common.ix.functions.Inherit","id":"property-sord","meta":{"private":true}},{"name":"updates","tagname":"property","owner":"sol.common.ix.functions.Inherit","id":"property-updates","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"checkUpdate","tagname":"method","owner":"sol.common.ix.functions.Inherit","id":"method-checkUpdate","meta":{"private":true}},{"name":"inheritField","tagname":"method","owner":"sol.common.ix.functions.Inherit","id":"method-inheritField","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.FunctionBase","id":"method-initialize","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.functions.Inherit","id":"method-process","meta":{}},{"name":"startInheritKeywordingJob","tagname":"method","owner":"sol.common.ix.functions.Inherit","id":"method-startInheritKeywordingJob","meta":{"private":true}},{"name":"RF_sol_function_Inherit","tagname":"method","owner":"sol.common.ix.functions.Inherit","id":"static-method-RF_sol_function_Inherit","meta":{"static":true}},{"name":"onEnterNode","tagname":"method","owner":"sol.common.ix.functions.Inherit","id":"static-method-onEnterNode","meta":{"static":true}},{"name":"onExitNode","tagname":"method","owner":"sol.common.ix.functions.Inherit","id":"static-method-onExitNode","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.functions.Inherit","short_doc":"This module handles the inheritance of index fields from the parent. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a><div class='subclass '><strong>sol.common.ix.functions.Inherit</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.AsyncUtils' rel='sol.common.AsyncUtils' class='docClass'>sol.common.AsyncUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Config' rel='sol.common.Config' class='docClass'>sol.common.Config</a></div><div class='dependency'><a href='#!/api/sol.common.ConfigMixin' rel='sol.common.ConfigMixin' class='docClass'>sol.common.ConfigMixin</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit' target='_blank'>sol.common.ix.functions.Inherit.js</a></div></pre><div class='doc-contents'><p>This module handles the inheritance of index fields from the parent.</p>\n\n<p>The configuration, which fields should be inherited is done via <a href=\"#!/api/sol.common.ix.functions.Inherit-cfg-fields\" rel=\"sol.common.ix.functions.Inherit-cfg-fields\" class=\"docClass\">fields</a>.\nIf inherited fields already have a value, they will not be overridden by default.\nThis behaviour can be altered via an <code>override</code> flag in each field configuration.</p>\n\n<p>Without any fields-configuration the ELO standard mechanism for inheritance\nwill be triggered. The objId and it's children will be passed to the mechanism.\nAll fields will be inherited according to their mask field configuration.\nYou can wait until the inheritance is finished with the <a href=\"#!/api/sol.common.ix.functions.Inherit-cfg-waitUntilFinished\" rel=\"sol.common.ix.functions.Inherit-cfg-waitUntilFinished\" class=\"docClass\">waitUntilFinished</a> parameter.</p>\n\n<h1>As workflow node</h1>\n\n<p>ObjId is set based on the element that the workflow is attached to.\nFollowing configuration should be applied to the comments field and would inherit the name of the parent,\nthe field 'MY_INHERITED' and the map field 'MY_INHERITED_MAP' (existing values will not be overridden).\nAdditionally the field MY_INHERITED_2 will be <i>inherited</i> from the field 'MY_OTHER' from the parent</p>\n\n<pre><code>{\n  \"fields\": [\n    { \"type\": \"SORD\", \"key\": \"name\" },\n    { \"type\": \"GRP\", \"key\": \"MY_INHERITED\" },\n    { \"type\": \"MAP\", \"key\": \"MY_INHERITED_MAP\" },\n    { \"type\": \"GRP\", \"key\": \"MY_INHERITED_2\", \"source\": { \"type\": \"GRP\", \"key\": \"MY_OTHER\" } }\n  ]\n}\n</code></pre>\n\n<h1>As IX function call</h1>\n\n<p>In addition to the workflow node configuration the objId must be passed.\nThe following example would inherit the field 'MY_INHERITED' from the parent and override an exiting value.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>(\"RF_sol_function_Inherit\", {\n  objId: \"4711\",\n  fields: [\n    { \"type\": \"GRP\", \"key\": \"MY_INHERITED\", \"override\": true }\n  ]\n});\n</code></pre>\n      <p class='version-tag'>Version: <b>1.02.003</b></p>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-objId' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-cfg-objId' class='name expandable'>objId</a> : String<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>Object ID</p>\n</div><div class='long'><p>Object ID</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-cfg-objId\" rel=\"sol.common.ix.FunctionBase-cfg-objId\" class=\"docClass\">sol.common.ix.FunctionBase.objId</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-fields' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-cfg-fields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-cfg-fields' class='name expandable'>fields</a> : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Optional parameter. ...</div><div class='long'><p>Optional parameter. When empty we're using the server-side\ninheritKeywording feature to copy all inheritable fields\n(as configured in the mask fields)</p>\n\n<p>With this parameter you're independent of the mask configuration.\nYou can choose which fields should be inherited by defining them\nin this parameter.</p>\n\n<p>Object containing the configuration for the inherited fields:</p>\n\n<pre><code>[\n  { type: \"SORD\", key: \"name\" },\n  { type: \"GRP\", key: \"MY_FIELD\", \"override\": true }\n]\n</code></pre>\n\n<p>Currently only \"SORD\" and \"GRP\" are supported as <code>type</code>.</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;objId&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-sleepTime' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-cfg-sleepTime' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-cfg-sleepTime' class='name expandable'>sleepTime</a> : Integer<span class=\"signature\"></span></div><div class='description'><div class='short'>Miliseconds to wait between each check of the current\ninheritance job state ...</div><div class='long'><p>Miliseconds to wait between each check of the current\ninheritance job state</p>\n<p>Defaults to: <code>200</code></p></div></div></div><div id='cfg-waitUntilFinished' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-cfg-waitUntilFinished' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-cfg-waitUntilFinished' class='name expandable'>waitUntilFinished</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>This parameter only works when the fields parameter is empty\n\nWhen true we're waiting for the inheritance to finish. ...</div><div class='long'><p>This parameter only works when the fields parameter is empty</p>\n\n<p>When true we're waiting for the inheritance to finish.\nThe inheritKeywording job is async when this parameter is false</p>\n<p>Defaults to: <code>false</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div><div id='property-parentSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-property-parentSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-property-parentSord' class='name expandable'>parentSord</a> : de.elo.ix.client.Sord<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-sord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-property-sord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-property-sord' class='name expandable'>sord</a> : de.elo.ix.client.Sord<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-updates' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-property-updates' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-property-updates' class='name expandable'>updates</a> : Object[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-checkUpdate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-method-checkUpdate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-method-checkUpdate' class='name expandable'>checkUpdate</a>( <span class='pre'>parentValue, targetValue, override</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>parentValue</span> : String<div class='sub-desc'><p>Parent value</p>\n</div></li><li><span class='pre'>targetValue</span> : String<div class='sub-desc'><p>Target value</p>\n</div></li><li><span class='pre'>override</span> : Boolean<div class='sub-desc'><p>Override value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-inheritField' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-method-inheritField' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-method-inheritField' class='name expandable'>inheritField</a>( <span class='pre'>cfg</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cfg</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>This module handles inheritance of index fields from the parent. ...</div><div class='long'><p>This module handles inheritance of index fields from the parent.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-process\" rel=\"sol.common.ix.FunctionBase-method-process\" class=\"docClass\">sol.common.ix.FunctionBase.process</a></p></div></div></div><div id='method-startInheritKeywordingJob' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-method-startInheritKeywordingJob' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-method-startInheritKeywordingJob' class='name expandable'>startInheritKeywordingJob</a>( <span class='pre'>objId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Start ID for the processTree</p>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_function_Inherit' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-static-method-RF_sol_function_Inherit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-static-method-RF_sol_function_Inherit' class='name expandable'>RF_sol_function_Inherit</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n...</div><div class='long'><p>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n</div></li></ul></div></div></div><div id='static-method-onEnterNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-static-method-onEnterNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-static-method-onEnterNode' class='name expandable'>onEnterNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called before a workflow node is activated. ...</div><div class='long'><p>This function is called before a workflow node is activated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The activated node ID</p>\n</div></li></ul></div></div></div><div id='static-method-onExitNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Inherit'>sol.common.ix.functions.Inherit</span><br/><a href='source/sol.common.ix.functions.Inherit.html#sol-common-ix-functions-Inherit-static-method-onExitNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Inherit-static-method-onExitNode' class='name expandable'>onExitNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called after a workflow node is deactivated. ...</div><div class='long'><p>This function is called after a workflow node is deactivated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The deactivated node ID</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});